/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.panel;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.panel.BasePanelJSONHandler;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import org.json.JSONObject;

public class MetaTabPanelJSONHandler
extends BasePanelJSONHandler<MetaTabPanel> {
    @Override
    public void fromJSONImpl(MetaTabPanel meta, JSONObject json) throws Throwable {
        super.fromJSONImpl(meta, json);
        meta.setTabPosition(Integer.valueOf(json.optInt("tabPosition")));
        meta.setTabMode(Integer.valueOf(json.optInt("tabMode")));
        meta.setIndicatorColor(json.optString("indicatorColor"));
        meta.setShowHead(Boolean.valueOf(json.optBoolean("showHead")));
        meta.setHoverHead(Boolean.valueOf(json.optBoolean("hoverHead")));
        String s = json.optString("indicatorHeight");
        if (s != null && !s.isEmpty()) {
            meta.setIndicatorHeight(DefSize.parse((String)s));
        }
        if ((s = json.optString("itemChanged")) != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("ItemChanged");
            script.setContent(s);
            meta.setItemChanged(script);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaTabPanel meta, DefaultSerializeContext hook) throws Throwable {
        MetaBaseScript itemChanged;
        super.toJSONImpl(json, meta, hook);
        JSONHelper.writeToJSON((JSONObject)json, (String)"tabPosition", (Object)meta.getTabPosition());
        JSONHelper.writeToJSON((JSONObject)json, (String)"tabMode", (Object)meta.getTabMode());
        JSONHelper.writeToJSON((JSONObject)json, (String)"indicatorColor", (Object)meta.getIndicatorColor());
        JSONHelper.writeToJSON((JSONObject)json, (String)"showHead", (Object)meta.isShowHead());
        JSONHelper.writeToJSON((JSONObject)json, (String)"hoverHead", (Object)meta.isHoverHead());
        DefSize indicatorHeight = meta.getIndicatorHeight();
        if (indicatorHeight != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"indicatorHeight", (String)indicatorHeight.toString(), (String)"");
        }
        if ((itemChanged = meta.getItemChanged()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"itemChanged", (Object)itemChanged.getContent().trim());
        }
    }

    @Override
    public MetaTabPanel newInstance() {
        return new MetaTabPanel();
    }
}

