/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;
import org.json.JSONObject;

public class MetaSwimlineJSONHandler
extends AbstractBPMElementJSONHandler<MetaSwimline> {
    @Override
    public void fromJSONImpl(MetaSwimline meta, JSONObject json) throws Throwable {
        super.fromJSONImpl(meta, json);
        meta.setCaption(json.optString("caption"));
        meta.setDirection(json.optString("direction"));
        JSONObject o = json.optJSONObject("swimlinePosition");
        if (o != null) {
            MetaSwimlinePosition position = BPMJSONHandlerUtil.unbuild(MetaSwimlinePosition.class, o);
            meta.setPosition(position);
        }
        if ((o = json.optJSONObject("swimlineSize")) != null) {
            MetaSwimlineSize size = BPMJSONHandlerUtil.unbuild(MetaSwimlineSize.class, o);
            meta.setSize(size);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaSwimline meta, BPMSerializeContext hook) throws Throwable {
        MetaSwimlineSize size;
        super.toJSONImpl(json, meta, hook);
        String caption = hook.getProcessString("BPM_Node", meta.getKey(), meta.getCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)caption);
        JSONHelper.writeToJSON((JSONObject)json, (String)"direction", (Object)meta.getDirection());
        MetaSwimlinePosition position = meta.getPosition();
        if (position != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)position, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"swimlinePosition", (Object)o);
        }
        if ((size = meta.getSize()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)size, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"swimlineSize", (Object)o);
        }
    }

    @Override
    public MetaSwimline newInstance() {
        return new MetaSwimline();
    }
}

