/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.bpm.MetaNodeJSONHandler;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaStateJSONHandler
extends MetaNodeJSONHandler<MetaState> {
    @Override
    public void fromJSONImpl(MetaState meta, JSONObject json) throws Throwable {
        JSONObject o;
        super.fromJSONImpl(meta, json);
        meta.setStatus(json.optString("status"));
        meta.setCreateTrigger(json.optString("createTrigger"));
        meta.setFinishTrigger(json.optString("finishTrigger"));
        meta.setFieldKey(json.optString("fieldKey"));
        meta.setFieldValue(json.optString("fieldValue"));
        JSONArray array = json.optJSONArray("participatorCollection");
        if (array != null) {
            MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String tagName = jsonObject.optString("tagName");
                if ("Dictionary".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
                    continue;
                }
                if ("MidFormula".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
                    continue;
                }
                if ("Query".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
                    continue;
                }
                if ("Relation".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
                    continue;
                }
                if (!"ExternalLink".equalsIgnoreCase(tagName)) continue;
                participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
            }
            meta.setParticipatorCollection(participatorCollection);
        }
        if ((o = json.optJSONObject("perm")) != null) {
            MetaPerm perm = BPMJSONHandlerUtil.unbuild(MetaPerm.class, o);
            meta.setPerm(perm);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaState meta, BPMSerializeContext hook) throws Throwable {
        MetaPerm perm;
        super.toJSONImpl(json, meta, hook);
        JSONHelper.writeToJSON((JSONObject)json, (String)"status", (Object)meta.getStatus());
        JSONHelper.writeToJSON((JSONObject)json, (String)"createTrigger", (Object)meta.getCreateTrigger());
        JSONHelper.writeToJSON((JSONObject)json, (String)"finishTrigger", (Object)meta.getFinishTrigger());
        JSONHelper.writeToJSON((JSONObject)json, (String)"fieldKey", (Object)meta.getFieldKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"fieldValue", (Object)meta.getFieldValue());
        MetaParticipatorCollection participatorCollection = meta.getParticipatorCollection();
        if (participatorCollection != null) {
            JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)participatorCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"participatorCollection", (Object)array);
        }
        if ((perm = meta.getPerm()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)perm, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"perm", (Object)o);
        }
    }

    @Override
    public MetaState newInstance() {
        return new MetaState();
    }
}

