package com.bokesoft.yes.meta.json.report;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReportGridCell;
import com.bokesoft.yigo.meta.report.MetaReportGridRow;

public class MetaReportGridRowJSONHandler extends AbstractJSONHandler<MetaReportGridRow,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportGridRow meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_LINEBREAK, meta.isLineBreak());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_GROUPKEY, meta.getGroupKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_GROUPLEVEL, meta.getGroupLevel());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_FILTER, meta.getFilter());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_DTLCOUNTEVERYPAGE, meta.getDtlCountEveryPage());
		
		JSONArray array = ReportJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_CELLS, array);
	}

	@Override
	public MetaReportGridRow newInstance() {
		return new MetaReportGridRow();
	}

	@Override
	public void fromJSONImpl(MetaReportGridRow meta, JSONObject json) throws Throwable {
		meta.setHeight(json.optInt(JSONConstants.COMMON_HEIGHT));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setBackColor(json.optString(JSONConstants.REPORT_BACKCOLOR));
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setLineBreak(json.optBoolean(JSONConstants.REPORT_LINEBREAK));
		meta.setGroupKey(json.optString(JSONConstants.REPORT_GROUPKEY));
		meta.setGroupLevel(json.optInt(JSONConstants.REPORT_GROUPLEVEL));
		meta.setFilter(json.optString(JSONConstants.REPORT_FILTER));
		meta.setDtlCountEveryPage(json.optInt(JSONConstants.REPORT_DTLCOUNTEVERYPAGE));
		
		JSONArray array = json.optJSONArray(JSONConstants.GRID_CELLS);
		if( array != null ) {
			for( int i = 0;i < array.length();i++ ) {
				meta.add(ReportJSONHandlerUtil.unbuild(MetaReportGridCell.class, array.optJSONObject(i)));
			}
		}
	}

}
