package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportFont;

public class MetaReportFontJSONHandler extends AbstractJSONHandler<MetaReportFont,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportFont meta, SolutionSerializeContext hook) throws Throwable {	
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_NAME, meta.getName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SIZE, meta.getSize());
		JSONHelper.writeToJSON(json, JSONConstants.FONT_BOLD, meta.isBold());
		JSONHelper.writeToJSON(json, JSONConstants.FONT_ITALIC, meta.isItalic());
		JSONHelper.writeToJSON(json, JSONConstants.FONT_UNDERLINESTYLE, meta.getUnderlineStyle());
	}

	@Override
	public MetaReportFont newInstance() {
		return new MetaReportFont();
	}

	@Override
	public void fromJSONImpl(MetaReportFont meta, JSONObject json) throws Throwable {
		meta.setName(json.optString(JSONConstants.COMMON_NAME));
		meta.setSize(json.optInt(JSONConstants.COMMON_SIZE));
		meta.setBold(json.optBoolean(JSONConstants.FONT_BOLD));
		meta.setItalic(json.optBoolean(JSONConstants.FONT_ITALIC));
		meta.setUnderlineStyle(json.optInt(JSONConstants.FONT_UNDERLINESTYLE));
	}

}
