package com.bokesoft.yes.meta.json.panel.gridpanel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.panel.BasePanelJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.ExtraLayoutType;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;

public class MetaGridLayoutPanelJSONHandler extends BasePanelJSONHandler<MetaGridLayoutPanel> {
	
	@Override
	public void fromJSONImpl(MetaGridLayoutPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setOddColumnColor(json.optString(JSONConstants.GRIDLAYOUTPANEL_ODDCOLUMNCOLOR));
		meta.setForceLayout(json.optBoolean(JSONConstants.GRIDLAYOUTPANEL_FORCELAYOUT));
				
		JSONObject layout = json.optJSONObject(JSONConstants.BASEPANEL_LAYOUT);
		
		JSONObject o = layout.optJSONObject(JSONConstants.LAYOUT_ROWCOLLECTION);
		if( o != null ) {
			MetaRowDefCollection rowDefCollection = UIJSONHandlerUtil.unbuild(MetaRowDefCollection.class, o);
			meta.setRowDefCollection(rowDefCollection);
		}
		
		o = layout.optJSONObject(JSONConstants.LAYOUT_COLUMNCOLLECTION);
		if( o != null ) {
			MetaColumnDefCollection columnDefCollection = UIJSONHandlerUtil.unbuild(MetaColumnDefCollection.class, o);
			meta.setColumnDefCollection(columnDefCollection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGridLayoutPanel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ODDCOLUMNCOLOR, meta.getOddColumnColor());
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_FORCELAYOUT, meta.isForceLayout());	

		MetaExtraLayout metaExtraLayout = meta.getMetaExtraLayout();
		if (metaExtraLayout != null){
			JSONObject o = UIJSONHandlerUtil.build(metaExtraLayout, hook);
			o.put(JSONConstants.GRIDLAYOUTPANEL_EXTRA_LAYOUT_TYPE, ExtraLayoutType.toString(metaExtraLayout.getType()));
			json.put(JSONConstants.GRIDLAYOUTPANEL_EXTRA_LAYOUT, o);

		}
	}

	@Override
	public MetaGridLayoutPanel newInstance() {
		return new MetaGridLayoutPanel();
	}
}
