package com.bokesoft.yes.meta.json.panel.collapsepanel;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseItem;

public class MetaCollapseItemJSONHandler extends BaseComponentJSONHandler<MetaCollapseItem> {

	@Override
	public void fromJSONImpl(MetaCollapseItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		MetaBaseScript collapseClick = new MetaBaseScript(JSONConstants.Event_OnCollapse);
		collapseClick.setContent(JSONHelper.readFromJSON(json, JSONConstants.Event_OnCollapse, ""));
		meta.setCollapseClick(collapseClick);
		MetaBaseScript expandClick = new MetaBaseScript(JSONConstants.Event_OnExpand);
		expandClick.setContent(JSONHelper.readFromJSON(json, JSONConstants.Event_OnExpand, ""));
		meta.setExpandClick(expandClick);
		meta.setCaption(JSONHelper.readFromJSON(json, JSONConstants.COMMON_CAPTION, ""));
		meta.setIcon(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_ICON, ""));
		meta.setTextOn(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_TEXTON, ""));
		meta.setTextOff(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_TEXTOFF, ""));
		meta.setIconLocation(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_ICONLOCATION, IconLocationType.LEFT));
		meta.setIsExpand(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_ISEXPAND, false));
		meta.setExpandIcon(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_EXPAND_ICON, ""));
		meta.setCollapseIcon(JSONHelper.readFromJSON(json, JSONConstants.COLLAPSE_COLLAPSE_ICON, "")); 
		String collapseHeight = json.optString(JSONConstants.COLLAPSE_COLLAPSE_HEIGHT);
		if( collapseHeight != null && !collapseHeight.isEmpty() ) {
			meta.setCollapseHeight(DefSize.parse(collapseHeight));
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.COLLAPSE_ITEMS);
		if(array != null){
			ArrayList<MetaComponent> compList = new ArrayList<>();
			for (int i = 0; i < array.length(); i++) {
				JSONObject jsonObject = array.optJSONObject(i);
				MetaComponent component = (MetaComponent) UIJSONHandlerUtil.unbuild(jsonObject);
				compList.add(component);
			}
			meta.setCompList(compList);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject itemJSON, MetaCollapseItem metaItem, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(itemJSON, metaItem, hook);
		ArrayList<MetaComponent> metaComponents = metaItem.getCompList();
        JSONArray items = new JSONArray();
        for (int i = 0; i < metaComponents.size(); i++) {
			MetaComponent metaComponent = metaComponents.get(i);
			JSONObject o = UIJSONHandlerUtil.build(metaComponent,hook);
			items.put(o);
		}
		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_ITEMS, items);
		MetaBaseScript collapseClick = metaItem.getCollapseClick();
		if(collapseClick != null){
			JSONHelper.writeToJSON(itemJSON, JSONConstants.Event_OnCollapse, collapseClick.getContent().trim());
		}
		MetaBaseScript expandClick = metaItem.getExpandClick();
		if(expandClick != null){
			JSONHelper.writeToJSON(itemJSON, JSONConstants.Event_OnExpand, expandClick.getContent().trim());
		}
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_CAPTION, metaItem.getCaption());
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_ICON, metaItem.getIcon());
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_TEXTON, metaItem.getTextOn());
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_TEXTOFF, metaItem.getTextOff());
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_ICONLOCATION, metaItem.getIconLocation());
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_ISEXPAND, metaItem.getIsExpand()); 
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_EXPAND_ICON, metaItem.getExpandIcon()); 
 		JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_COLLAPSE_ICON, metaItem.getCollapseIcon()); 

		DefSize collapseHeight = metaItem.getCollapseHeight();
		if( collapseHeight != null ) {
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COLLAPSE_COLLAPSE_HEIGHT, collapseHeight.toString(), "");
		}
	}
	
	@Override
	public MetaCollapseItem newInstance() {
		return new MetaCollapseItem();
	}

}
