package com.bokesoft.yes.meta.json.other;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;

public class MetaEntryItemJSONHandler extends AbstractJSONHandler<MetaEntryItem, SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaEntryItem meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLE, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_SHORTCUTS, meta.getShortKeys());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_PARAMETERS, meta.getParameters());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_SINGLE, meta.isSingle());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TARGET, meta.getTarget());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_PATH, meta.getType());
		
		JSONHelper.writeToJSON(json, JSONConstants.Event_Action, meta.getAction());
		JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, meta.getOnClick());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICONCODE, meta.getIconCode());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TCODE, meta.getTCode());
	}

	@Override
	public MetaEntryItem newInstance() {
		return new MetaEntryItem();
	}

	@Override
	public void fromJSONImpl(MetaEntryItem item, JSONObject json) throws Throwable {
		item.setKey(json.optString(JSONConstants.COMMON_KEY));
		item.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		item.setIcon(json.optString(JSONConstants.ENTRY_ICON));
		item.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		item.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
		item.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		item.setShortKeys(json.optString(JSONConstants.ENTRY_SHORTCUTS));
		item.setType(json.optInt(JSONConstants.COMMON_TYPE));
		item.setParameters(json.optString(JSONConstants.ENTRY_PARAMETERS));
		item.setSingle(json.optBoolean(JSONConstants.ENTRY_SINGLE));
		item.setTarget(json.optInt(JSONConstants.COMMON_TARGET));
		item.setPath(json.optString(JSONConstants.ENTRY_PATH));
		
		MetaBaseScript action = new MetaBaseScript(MetaConstants.Event_Action);
		action.setContent(json.optString(JSONConstants.Event_Action));
		item.setAction(action);
		
		MetaBaseScript onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
		onClick.setContent(json.optString(JSONConstants.Event_OnClick));
		item.setOnClick(onClick);
		item.setIconCode(json.optString(JSONConstants.COMMON_ICONCODE));
		item.setTCode(json.optString(JSONConstants.COMMON_TCODE));
	}

}
