package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRow;

public class MetaLayoutRowJSONHandler extends AbstractJSONHandler<MetaLayoutRow,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutRow meta, DefaultSerializeContext hook)
			throws Throwable {
		DefSize height = meta.getHeight();
		if( height != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
		}
	}

	@Override
	public void fromJSONImpl(MetaLayoutRow meta, JSONObject json) throws Throwable {
		String s = json.optString(JSONConstants.COMMON_HEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setHeight(DefSize.parse(s));
		}
	}

	@Override
	public MetaLayoutRow newInstance() {
		return new MetaLayoutRow();
	}

}
