package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaNavigationBarRightButton;

public class MetaNavigationBarRightButtonJSONHandler extends MetaBaseScriptJSONHandler<MetaNavigationBarRightButton,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationBarRightButton meta,
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
	}
	
	@Override
	public void fromJSONImpl(MetaNavigationBarRightButton meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
	}

	@Override
	public MetaNavigationBarRightButton newInstance() {
		return new MetaNavigationBarRightButton();
	}
}
