package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollapaseTypeEnum;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;

public class MetaLayoutSplitItemJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutSplitItem> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutSplitItem meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		DefSize size = meta.getSize();
		if( size != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_SIZE, size);
			JSONHelper.writeToJSON(json, JSONConstants.SPLITPANEL_FORWARD_COLLAPASED, meta.getForwardCollapased(), false);
			JSONHelper.writeToJSON(json, JSONConstants.SPLITPANEL_REVERSE_COLLAPASED, meta.getReverseCollapased(), false);
			JSONHelper.writeToJSON(json, JSONConstants.SPLITPANEL_TYPE, MetaSplitSizeCollapaseTypeEnum.getNameByType(meta.getType()), "None");
		}
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutSplitItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		String s = json.optString(JSONConstants.COMMON_SIZE);
		if (s != null && !s.isEmpty()) {
			meta.setSize(DefSize.parse(s));
		}
		
		if (json.has(JSONConstants.SPLITPANEL_TYPE)) {
			meta.setType(json.optInt(JSONConstants.SPLITPANEL_TYPE));
		}
		if (json.has(JSONConstants.SPLITPANEL_FORWARD_COLLAPASED)) {
			meta.setForwardCollapased(json.optBoolean(JSONConstants.SPLITPANEL_FORWARD_COLLAPASED));
		}
		if (json.has(JSONConstants.SPLITPANEL_REVERSE_COLLAPASED)) {
			meta.setReverseCollapased(json.optBoolean(JSONConstants.SPLITPANEL_REVERSE_COLLAPASED));
		}
	}
	
	@Override
	public MetaLayoutSplitItem newInstance() {
		return new MetaLayoutSplitItem();
	}
}
