package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

public class MetaLayoutSpanJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutSpan> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutSpan meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_Y, meta.getY());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_XSPAN, meta.getXSpan());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_YSPAN, meta.getYSpan());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, 
				meta.getHeight() != null ? meta.getHeight().toString() : null);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, 
				meta.getWidth() != null ? meta.getWidth().toString() : null);
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutSpan meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setX(json.optInt(JSONConstants.COMPONENT_X));
		meta.setY(json.optInt(JSONConstants.COMPONENT_Y));
		meta.setXSpan(json.optInt(JSONConstants.COMPONENT_XSPAN));
		meta.setYSpan(json.optInt(JSONConstants.COMPONENT_YSPAN));
		String heightStr = json.optString(JSONConstants.COMMON_HEIGHT);
		if(!heightStr.isEmpty()){
			meta.setHeight(DefSize.parse(heightStr));
		}
		String widthStr = json.optString(JSONConstants.COMMON_WIDTH);
		if(!widthStr.isEmpty()){
			meta.setWidth(DefSize.parse(widthStr));
		}
	}
	
	@Override
	public MetaLayoutSpan newInstance() {
		return new MetaLayoutSpan();
	}
}
