package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimeCountDownProperties;

public class MetaTimeCountDownPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaTimeCountDownProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTimeCountDownProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TIMECOUNTDOWN_FORMAT, meta.getFormat());
		MetaBaseScript onFinish = meta.getOnFinish();
		if( meta.getOnFinish() != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TIMECOUNTDOWN_ONFINISH, onFinish.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaTimeCountDownProperties meta, JSONObject json) throws Throwable {
		meta.setFormat(json.optString(JSONConstants.TIMECOUNTDOWN_FORMAT));
		String s = json.optString(JSONConstants.TIMECOUNTDOWN_ONFINISH);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnFinish(script);
		}
	}

	@Override
	public MetaTimeCountDownProperties newInstance() {
		return new MetaTimeCountDownProperties();
	}
}
