package com.bokesoft.yes.meta.json.com.properties;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSplitButtonProperties;

public class MetaSplitButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaSplitButtonProperties> {
	
	@Override
	public void fromJSONImpl(MetaSplitButtonProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.DROPDOWNBUTTON_ICON));
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.DROPDOWNBUTTON_ITEMS);
		if( array != null ) {
			MetaDropdownItemCollection collection = unbuild(array);
			meta.setItemCollection(collection);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSplitButtonProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SPLITBUTTON_ICON, meta.getIcon());

		MetaDropdownItemCollection collection = meta.getItemCollection();
		if( collection != null ) {
			JSONArray array = this.buildItems(key, collection, hook);
			JSONHelper.writeToJSON(json, JSONConstants.SPLITBUTTON_ITEMS, array);
		}
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent());
		}
	}
	
	private JSONArray buildItems(String key, MetaDropdownItemCollection collection, DefaultSerializeContext hook) throws Throwable{
		JSONArray array = new JSONArray();
		Iterator<MetaDropdownItem> it = collection.iterator();
		MetaDropdownItem item = null;
		while(it.hasNext()) {
			item = it.next();
			JSONObject o = new JSONObject();
			JSONHelper.writeToJSON(o, JSONConstants.DROPDOWNITEM_KEY, item.getKey());
			String text = hook.getString(GroupKeyTable.STR_ITEMS, key, "Item-"+item.getKey(), item.getText());
			JSONHelper.writeToJSON(o, JSONConstants.DROPDOWNITEM_TEXT, text);
			JSONHelper.writeToJSON(o, JSONConstants.DROPDOWNITEM_SEPARATOR, item.getSeparator());
			MetaBaseScript onClick = item.getOnClick();
			if(onClick != null) {
				JSONHelper.writeToJSON(o, JSONConstants.COMBOBOX_FORMULA, onClick.getContent().trim());
			}
			array.put(o);
		}
		return array;
	}
	
	private MetaDropdownItemCollection unbuild(JSONArray array) {
		MetaDropdownItemCollection collection = new MetaDropdownItemCollection();
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			MetaDropdownItem item = new MetaDropdownItem();
			item.setKey(o.optString(JSONConstants.DROPDOWNITEM_KEY));
			item.setText(o.optString(JSONConstants.DROPDOWNITEM_TEXT));
			item.setSeparator(o.optBoolean(JSONConstants.DROPDOWNITEM_SEPARATOR));
			
			String s = o.optString(JSONConstants.COMBOBOX_FORMULA);
			if( s != null && !s.isEmpty() ) {
				MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
				script.setContent(s);
				item.setOnClick(script);
			}
			collection.add(item);
		}
		return collection;
	}

	@Override
	public MetaSplitButtonProperties newInstance() {
		return new MetaSplitButtonProperties();
	}

}
