package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;

public class MetaRelativeTimePropertiesJSONHandler extends BasePropertiesJSONHandler<MetaRelativeTimeProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaRelativeTimeProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.RELATIVETIME_INTERVAL, meta.getInterval());
	}

	@Override
	public void fromJSONImpl(MetaRelativeTimeProperties meta, JSONObject json) throws Throwable {
		meta.setInterval(json.optInt(JSONConstants.RELATIVETIME_INTERVAL));
	}

	@Override
	public MetaRelativeTimeProperties newInstance() {
		return new MetaRelativeTimeProperties();
	}
}
