package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPopButtonProperties;

public class MetaPopButtonPropertiesJSONHandler extends MetaButtonPropertiesJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaButtonProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		super.toJSONImpl(json, meta, hook, key);
		MetaPopButtonProperties metaPop = (MetaPopButtonProperties) meta;
		JSONHelper.writeToJSON(json, JSONConstants.POPBUTTON_LOCATION, metaPop.getLocation());
		MetaComponent root = metaPop.getRoot();
		if ( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.POPBUTTON_ROOT, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaButtonProperties meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		MetaPopButtonProperties metaPop = (MetaPopButtonProperties) meta;
		metaPop.setLocation(json.optInt(JSONConstants.POPBUTTON_LOCATION));
		JSONObject o = json.optJSONObject(JSONConstants.POPBUTTON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			metaPop.setRoot(root);
		}
	}
	
	@Override
	public MetaButtonProperties newInstance() {
		return new MetaPopButtonProperties();
	}
}
