package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaPasswordEditorPropertiesJSONHandler extends MetaTextEditorPropertiesJSONHandler {

	@Override
	public void toJSONImpl(JSONObject json, MetaTextEditorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		super.toJSONImpl(json, meta, hook, key);
		MetaPasswordEditorProperties properties = (MetaPasswordEditorProperties)meta;
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SAFEINPUT, properties.isSafeInput());
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SHOWSWITCHICON, properties.isShowSwitchIcon());
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_STYLE, properties.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SHOWPLAINTEXT, properties.isShowPlainText());
		JSONHelper.writeToJSON(json, JSONConstants.PASSWORD_SPACING, properties.getSpacing().toString());
	}
	
	@Override
	public void fromJSONImpl(MetaTextEditorProperties meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		MetaPasswordEditorProperties properties = (MetaPasswordEditorProperties)meta;
		properties.setSafeInput(json.optBoolean(JSONConstants.PASSWORD_SAFEINPUT));
		properties.setShowSwitchIcon(json.optBoolean(JSONConstants.PASSWORD_SHOWSWITCHICON));
		properties.setStyle(json.optInt(JSONConstants.PASSWORD_STYLE));
		properties.setShowPlainText(json.optBoolean(JSONConstants.PASSWORD_SHOWPLAINTEXT));
		properties.setSpacing(DefSize.parse(json.optString(JSONConstants.PASSWORD_SPACING)));
	}
	
	@Override
	public MetaTextEditorProperties newInstance() {
		return new MetaPasswordEditorProperties();
	}
}
