package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMonthPickerProperties;

public class MetaMonthPickerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaMonthPickerProperties>{
	
	public void toJSONImpl(JSONObject json, MetaMonthPickerProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.MONTHPICKER_FORMATSTR, meta.getDateFormat());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.MONTHPICKER_EDITTYPE, meta.getEditType());
	}

	@Override
	public void fromJSONImpl(MetaMonthPickerProperties meta, JSONObject json) throws Throwable {
		meta.setDateFormat(json.optString(JSONConstants.MONTHPICKER_FORMATSTR));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setEditType(json.optInt(JSONConstants.MONTHPICKER_EDITTYPE));
	}

	@Override
	public MetaMonthPickerProperties newInstance() {
		return new MetaMonthPickerProperties();
	}
	
}
