package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;

public class MetaImagePropertiesJSONHandler extends BasePropertiesJSONHandler<MetaImageProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaImageProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_STRETCH, meta.isStretch());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MAXSIZE, meta.getMaxSize());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGECUT, meta.isImageCut());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_RADIUS, meta.getRadius());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_FILENAME, meta.getFileName());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_VIEWMODE,meta.getViewMode());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_VIEWOPT, meta.isViewOpt());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MASKIMAGE, meta.getMaskImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SHOWTHUMBNAIL, meta.isShowThumbnail());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_UPLOADPROGRESS, meta.getUploadProgress());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MAXSHOWSIZE, meta.getMaxShowSize());
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaImageProperties meta, JSONObject json) throws Throwable {
		meta.setSourceType(json.optInt(JSONConstants.IMAGE_SOURCETYPE));
		meta.setImage(json.optString(JSONConstants.IMAGE_IMAGE));
		meta.setStretch(json.optBoolean(JSONConstants.IMAGE_STRETCH));
		meta.setMaxSize(json.optInt(JSONConstants.IMAGE_MAXSIZE));
		meta.setImageCut(json.optBoolean(JSONConstants.IMAGE_IMAGECUT));
		meta.setImageScaleType(json.optInt(JSONConstants.IMAGE_IMAGESCALETYPE));
		meta.setPromptImage(json.optString(JSONConstants.IMAGE_PROMPTIMAGE));
		meta.setRadius(json.optInt(JSONConstants.IMAGE_RADIUS));
		meta.setFileName(json.optString(JSONConstants.IMAGE_FILENAME));
		meta.setViewMode(json.optInt(JSONConstants.IMAGE_VIEWMODE));
		meta.setViewOpt(json.optBoolean(JSONConstants.IMAGE_VIEWOPT));
		meta.setMaskImage(json.optString(JSONConstants.IMAGE_MASKIMAGE));
		meta.setShowThumbnail(json.optBoolean(JSONConstants.IMAGE_SHOWTHUMBNAIL));
		meta.setUploadProgress(json.optInt(JSONConstants.IMAGE_UPLOADPROGRESS));
		meta.setMaxShowSize(json.optInt(JSONConstants.IMAGE_MAXSHOWSIZE));
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
	}

	@Override
	public MetaImageProperties newInstance() {
		return new MetaImageProperties();
	}
}
