package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;

public class MetaGIFImagePropertiesJSONHandler extends BasePropertiesJSONHandler<MetaGIFImageProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGIFImageProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType());
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null && onClick.getContent() != null && !onClick.getContent().isEmpty()){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaGIFImageProperties meta, JSONObject json) throws Throwable {
		meta.setSourceType(json.optInt(JSONConstants.IMAGE_SOURCETYPE));
		meta.setImage(json.optString(JSONConstants.IMAGE_IMAGE));
		meta.setImageScaleType(json.optInt(JSONConstants.IMAGE_IMAGESCALETYPE));
		
		String onClickContent = json.optString(JSONConstants.Event_OnClick);
		if(!onClickContent.isEmpty()){
			MetaBaseScript onClick = new MetaBaseScript(JSONConstants.Event_OnClick);
			onClick.setContent(onClickContent);
			meta.setOnClick(onClick);
		}
	}

	@Override
	public MetaGIFImageProperties newInstance() {
		return new MetaGIFImageProperties();
	}
}
