package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;
import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboViewProperties;

public class MetaComboViewPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaComboViewProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaComboViewProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICON,  meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICONLOCATION, meta.getIconLocation());
		MetaComponent root = meta.getRoot();
		if ( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaComboViewProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.BUTTON_ICON));
		meta.setIconLocation(json.optInt(JSONConstants.BUTTON_ICONLOCATION));
		JSONObject rootObject = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if(rootObject != null){
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(rootObject);
			meta.setRoot(root);
		}
	}

	@Override
	public MetaComboViewProperties newInstance() {
		return new MetaComboViewProperties();
	}
}

