package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.BarCodeType;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;

public class MetaBarCoderPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaBarCoderProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaBarCoderProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BARCODER_CODETYPE, meta.getCodeType());
	}

	@Override
	public void fromJSONImpl(MetaBarCoderProperties meta, JSONObject json) throws Throwable {
		meta.setCodeType(json.optInt(JSONConstants.BARCODER_CODETYPE, BarCodeType.QR_CODE));
	}

	@Override
	public MetaBarCoderProperties newInstance() {
		return new MetaBarCoderProperties();
	}

}
