package com.bokesoft.yes.meta.json.com.moduleEditor;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleEditor;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleItem;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleItemCollection;

public class MetaModuleEditorJSONHandler extends BaseComponentJSONHandler<MetaModuleEditor> {

	@Override
	public void toJSONImpl(JSONObject json, MetaModuleEditor meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_SOURCETABLEKEY, meta.getSourceTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_SOURCECAPTION, meta.getSourceCaption());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_GAP, meta.getGap());

		MetaModuleItemCollection itemCollection = meta.getItemCollection();
		if (itemCollection != null && itemCollection.size() > 0) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, itemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		}

		MetaBaseScript formulaItems = meta.getFormulaItems();
		if (formulaItems != null) {
			JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_FORMULAITEMS, formulaItems.getContent().trim());
		}
	}

	@Override
	public void fromJSONImpl(MetaModuleEditor meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		meta.setTableKey(json.optString(JSONConstants.MODULEEDITOR_TABLEKEY));
		meta.setSourceType(json.optInt(JSONConstants.MODULEEDITOR_SOURCETYPE));
		meta.setSourceTableKey(json.optString(JSONConstants.MODULEEDITOR_SOURCETABLEKEY));
		meta.setSourceCaption(json.optString(JSONConstants.MODULEEDITOR_SOURCECAPTION));
		meta.setColumnCount(json.optInt(JSONConstants.MODULEEDITOR_COLUMNCOUNT));
		meta.setGap(json.optInt(JSONConstants.MODULEEDITOR_GAP));

		JSONArray array = json.optJSONArray(JSONConstants.NAVIGATIONLIST_ITEMS);
		if (array != null && array.length() > 0) {
			MetaModuleItemCollection itemCollection = new MetaModuleItemCollection();
			List<MetaModuleItem> list = UIJSONHandlerUtil.unbuild(MetaModuleItem.class, array);
			itemCollection.addAll(list);
			meta.setItemCollection(itemCollection);
		}
		String s = json.optString(JSONConstants.MODULEEDITOR_FORMULAITEMS);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.MODULEEDITOR_FORMULAITEMS);
			script.setContent(s);
			meta.setFormulaItems(script);
		}
	}

	@Override
	public MetaModuleEditor newInstance() {
		return new MetaModuleEditor();
	}

}
