package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewItem;

public class MetaListViewItemJSONHandler extends AbstractJSONHandler<MetaListViewItem,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaListViewItem meta, DefaultSerializeContext hook) throws Exception {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType());
	}

	@Override
	public void fromJSONImpl(MetaListViewItem meta, JSONObject json) throws Exception {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setImage(json.optString(JSONConstants.IMAGE_IMAGE));
		meta.setImageScaleType(json.optInt(JSONConstants.IMAGE_IMAGESCALETYPE));
	}

	@Override
	public MetaListViewItem newInstance() {
		return new MetaListViewItem();
	}
}
