package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowAreaExpand;

public class MetaRowAreaExpandJSONHandler extends MetaBaseScriptJSONHandler<MetaRowAreaExpand,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaRowAreaExpand meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWAREAEXPAND_START, meta.getStart());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWAREAEXPAND_COUNT, meta.getCount());
	}
	
	@Override
	public void fromJSONImpl(MetaRowAreaExpand meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStart(json.optInt(JSONConstants.GRID_ROWAREAEXPAND_START));
		meta.setCount(json.optInt(JSONConstants.GRID_ROWAREAEXPAND_COUNT));
	}
	
	@Override
	public MetaRowAreaExpand newInstance() {
		return new MetaRowAreaExpand();
	}
}
