package com.bokesoft.yes.meta.json.com.gantt;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaRelationship;

public class MetaRelationshipJSONHandler extends AbstractJSONHandler<MetaRelationship, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaRelationship meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_PREDECESSOR, meta.getPredecessor());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_SUCCESSOR, meta.getSuccessor());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_RELTYPE, meta.getType());
	}

	@Override
	public MetaRelationship newInstance() {
		return new MetaRelationship();
	}

	@Override
	public void fromJSONImpl(MetaRelationship meta, JSONObject json) throws Throwable {
		meta.setTableKey(json.optString(JSONConstants.GANTT_TABLEKEY));
		meta.setPredecessor(json.optString(JSONConstants.GANTT_PREDECESSOR));
		meta.setSuccessor(json.optString(JSONConstants.GANTT_SUCCESSOR));
		meta.setType(json.optString(JSONConstants.GANTT_RELTYPE));
	}

}
