package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItem;

public class MetaWizardItemJSONHandler extends AbstractJSONHandler<MetaWizardItem, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaWizardItem meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEM_CAPTIONFIELDKEY, meta.getCaptionFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEM_VALUEFIELDKEY, meta.getValueFieldKey());
	}

	@Override
	public void fromJSONImpl(MetaWizardItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaptionFieldKey(json.optString(JSONConstants.WIZARDITEM_CAPTIONFIELDKEY));
		meta.setValueFieldKey(json.optString(JSONConstants.WIZARDITEM_VALUEFIELDKEY));
	}

	@Override
	public MetaWizardItem newInstance() {
		return new MetaWizardItem();
	}
}
