package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;

public class MetaTableViewJSONHandler extends BaseComponentJSONHandler<MetaTableView> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTableView meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_ITEMANIM, meta.getItemAnim());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_LAYOUTANIM, meta.getLayoutAnim());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_INDICATOR, meta.isIndicator());
		JSONHelper.writeToJSON(json, JSONConstants.TABLEVIEW_HOVERHEAD, meta.isHoverHead());
		
		MetaTableRowCollection rows = meta.getRows();
		if( rows != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, rows);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		}		
	}
	
	@Override
	public void fromJSONImpl(MetaTableView meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setItemAnim(json.optString(JSONConstants.TABLEVIEW_ITEMANIM));
		meta.setLayoutAnim(json.optString(JSONConstants.TABLEVIEW_LAYOUTANIM));
		meta.setIndicator(json.optBoolean(JSONConstants.TABLEVIEW_INDICATOR));
		meta.setHoverHead(json.optBoolean(JSONConstants.TABLEVIEW_HOVERHEAD));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			MetaTableRowCollection collection = new MetaTableRowCollection();
			List<MetaTableRow> list = UIJSONHandlerUtil.unbuild(MetaTableRow.class, array);
			collection.addAll(0, list);
			meta.setRows(collection);
		}
	}

	@Override
	public MetaTableView newInstance() {
		return new MetaTableView();
	}

}