package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshFooter;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshHeader;

public class MetaRefreshControlJSONHandler extends BaseComponentJSONHandler<MetaRefreshControl> {

	@Override
	public void toJSONImpl(JSONObject json, MetaRefreshControl meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		MetaRefreshHeader rh = meta.getHeader();
		if (rh != null) {
			JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_HEADERREFRESHSCRIPT, UIJSONHandlerUtil.build(rh,hook));
		}
		MetaRefreshFooter rf = meta.getFooter();
		if (rf != null) {
			JSONObject footObj = new JSONObject();
			if(rf.getFormat() != null){
				footObj.put(JSONConstants.COMMON_FORMAT, UIJSONHandlerUtil.build(rf.getFormat(),hook));
			}
			footObj.put(JSONConstants.SCRIPT_CONTENT, rf.getContent());
			JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_FOOTERREFRESHSCRIPT, footObj);
		}
		MetaComponent root = meta.getRootComp();
		if (root != null) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_ROOT, o);
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_ORIENTATION, meta.getOrientation());
	}
	
	@Override
	public void fromJSONImpl(MetaRefreshControl meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		JSONObject o = json.optJSONObject(JSONConstants.REFRESHCONTROL_HEADERREFRESHSCRIPT);
		if (o != null) {
			meta.setHeader(UIJSONHandlerUtil.unbuild(MetaRefreshHeader.class, o));
		}
		o = json.optJSONObject(JSONConstants.REFRESHCONTROL_FOOTERREFRESHSCRIPT);
		if( o != null ) {
			MetaRefreshFooter refreshFooter = new MetaRefreshFooter();
			refreshFooter.setContent(o.optString(JSONConstants.SCRIPT_CONTENT));
			JSONObject formatObj = o.optJSONObject(JSONConstants.COMMON_FORMAT);
			if(formatObj != null){
				refreshFooter.setFormat(UIJSONHandlerUtil.unbuild(MetaFormat.class, formatObj));
			}
			meta.setFooter(refreshFooter);
		}
		
		o = json.optJSONObject(JSONConstants.REFRESHCONTROL_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRootComp(root);
		}
		meta.setOrientation(json.optInt(JSONConstants.COMPONENT_ORIENTATION));
	}

	@Override
	public MetaRefreshControl newInstance() {
		return new MetaRefreshControl();
	}

}
