package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapDraw;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapEvent;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapEventCollection;

public class MetaMapDrawJSONHandler extends BaseComponentJSONHandler<MetaMapDraw> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMapDraw meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.MAP_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.MAP_URL, meta.getURL());
		
		MetaParas metaParas = meta.getParas();
		if( metaParas != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, metaParas);
			JSONHelper.writeToJSON(json, JSONConstants.MAP_PARAS, array);
		}
		
		MetaMapEventCollection mapEventCollection = meta.getEventCollection();
		if(mapEventCollection != null){
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, mapEventCollection);
			JSONHelper.writeToJSON(json, JSONConstants.MAP_EVENT_COLLECTION, array);
			
		}
		
	}
	
	@Override
	public void fromJSONImpl(MetaMapDraw meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setType(json.optInt(JSONConstants.MAP_TYPE));
		meta.setURL(json.optString(JSONConstants.MAP_URL));
		
		JSONArray array = json.optJSONArray(JSONConstants.MAP_PARAS);
		if( array != null ) {
			MetaParas metaParas = new MetaParas();
			List<MetaPara> list = UIJSONHandlerUtil.unbuild(MetaPara.class, array);
			metaParas.addAll(list);
			meta.setParas(metaParas);
		}
		
		JSONArray eventArray = json.optJSONArray(JSONConstants.MAP_EVENT_COLLECTION);
		if( eventArray != null ) {
			MetaMapEventCollection metaMapEventCollection = new MetaMapEventCollection();
			List<MetaMapEvent> list = UIJSONHandlerUtil.unbuild(MetaMapEvent.class, eventArray);
			metaMapEventCollection.addAll(list);
			meta.setEventCollection(metaMapEventCollection);
		}
	}

	@Override
	public MetaMapDraw newInstance() {
		return new MetaMapDraw();
	}
	
}