package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.MetaFont;

public class MetaFontJSONHandler extends AbstractJSONHandler<MetaFont,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaFont meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.FONT_NAME, meta.getName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SIZE, meta.getSize());
		if(meta.getBold() != null){
			JSONHelper.writeToJSON(json, JSONConstants.FONT_BOLD, meta.getBold());
		}
		if(meta.getItalic() != null){
			JSONHelper.writeToJSON(json, JSONConstants.FONT_ITALIC, meta.getItalic());
		}
	}

	@Override
	public MetaFont newInstance() {
		return new MetaFont();
	}

	@Override
	public void fromJSONImpl(MetaFont meta, JSONObject json) throws Throwable {
		meta.setName(json.optString(JSONConstants.FONT_NAME));
		meta.setSize(json.optInt(JSONConstants.COMMON_SIZE));
		if(json.has(JSONConstants.FONT_BOLD)){
			meta.setBold(json.optBoolean(JSONConstants.FONT_BOLD));
		}
		if(json.has(JSONConstants.FONT_ITALIC)){
			meta.setItalic(json.optBoolean(JSONConstants.FONT_ITALIC));
		}
	}

}
