package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaConditionTarget;

public class MetaConditionTargetJSONHandler extends AbstractJSONHandler<MetaConditionTarget,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaConditionTarget meta, JSONObject json) throws Throwable {
		meta.setTableKey(json.optString(JSONConstants.CONDITION_TGTTABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.CONDITION_TGTCOLUMNKEY));
		meta.setTarget(json.optString(JSONConstants.CONDITION_TARGET));
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaConditionTarget meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TGTTABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TGTCOLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TARGET, meta.getTarget());
	}

	@Override
	public MetaConditionTarget newInstance() {
		return new MetaConditionTarget();
	}

}
