package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.common.MetaConditionTarget;
import com.bokesoft.yigo.meta.common.MetaConditionTargetCollection;
import com.bokesoft.yigo.meta.common.MetaCustomCondition;
import com.bokesoft.yigo.meta.common.MetaCustomConditionCollection;

public class MetaConditionJSONHandler extends AbstractJSONHandler<MetaCondition,DefaultSerializeContext>{

	@Override
	public void fromJSONImpl(MetaCondition meta, JSONObject json) throws Throwable {
		meta.setTag(json.optString(JSONConstants.CONDITION_TAG));
		meta.setSign(json.optInt(JSONConstants.CONDITION_CONDSIGN));
		meta.setGroup(json.optString(JSONConstants.CONDITION_GROUP));
		meta.setGroupHead(json.optBoolean(JSONConstants.CONDITION_GROUPHEAD));
		meta.setGroupTail(json.optBoolean(JSONConstants.CONDITION_GROUPTAIL));
		meta.setTableKey(json.optString(JSONConstants.COMMON_TABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.COMMON_COLUMNKEY));
		meta.setLimitToSource(json.optBoolean(JSONConstants.CONDITION_LIMITTOSOURCE));
		meta.setNeedReset(json.optBoolean(JSONConstants.CONDITION_NEEDRESET));
		meta.setLoadHistoryInput(json.optBoolean(JSONConstants.CONDITION_LOADHISTORYINPUT));
		meta.setOpValue(json.optString(JSONConstants.CONDITION_OPVALUE));
		meta.setImpl(json.optString(JSONConstants.CONDITION_IMPL));
		meta.setTarget(json.optString(JSONConstants.CONDITION_TAGRGET));
		
		JSONArray array = json.optJSONArray(JSONConstants.CONDITION_TAGRGETCOLLECTION);
		if( array != null ) {
			MetaConditionTargetCollection targets = new MetaConditionTargetCollection();
			List<MetaConditionTarget> items = UIJSONHandlerUtil.unbuild(MetaConditionTarget.class, array);
			targets.addAll(0, items);
			meta.setTargets(targets);
		}
		
		array = json.optJSONArray(JSONConstants.CONDITION_TAGRGETCOLLECTION);
		if( array != null ) {
			MetaCustomConditionCollection customs = new MetaCustomConditionCollection();
			List<MetaCustomCondition> items = UIJSONHandlerUtil.unbuild(MetaCustomCondition.class, array);
			customs.addAll(0, items);
			meta.setCustoms(customs);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCondition meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_CONDSIGN, meta.getSign());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_GROUP, meta.getGroup());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_GROUPHEAD, meta.isGroupHead());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_GROUPTAIL, meta.isGroupTail());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, ControlType.parse(meta.getTagName()));
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_LIMITTOSOURCE, meta.isLimitToSource());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_NEEDRESET, meta.needReset());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_LOADHISTORYINPUT, meta.isLoadHistoryInput());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_OPVALUE, meta.getOpValue());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_IMPL, meta.getImpl());
		JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TAGRGET, meta.getTarget());
		
		 MetaConditionTargetCollection targets = meta.getTargets();
		 if( targets != null ) {
			 JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, targets);
			 JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TAGRGETCOLLECTION, array);
		 }
		 
		MetaCustomConditionCollection customs = meta.getCustoms();
		if( customs != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, customs);
			JSONHelper.writeToJSON(json, JSONConstants.CONDITION_TAGRGETCOLLECTION, array);
		}
	}

	@Override
	public MetaCondition newInstance() {
		return new MetaCondition();
	}


}
