package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.com.properties.MetaComboViewPropertiesJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaComboView;

public class MetaComboViewJSONHandler extends BaseComponentJSONHandler<MetaComboView> {
	
	public MetaComboViewJSONHandler(){
		this.propertiesJSONHandler = new MetaComboViewPropertiesJSONHandler();
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaComboView meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		MetaComponent root = meta.getRoot();
		if ( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}
	}
	
	@Override
	public MetaComboView newInstance() {
		return new MetaComboView();
	}
	
}
