package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.timer.period.Moment;

public class MomentJSONHandler extends AbstractJSONHandler<Moment, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(Moment meta, JSONObject json) throws Throwable {
		meta.setHour(json.optInt(JSONConstants.TIMER_HOUR));
		meta.setMinute(json.optInt(JSONConstants.TIMER_MINUTE));
		meta.setSecond(json.optInt(JSONConstants.TIMER_SECOND));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, Moment meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_HOUR, meta.getHour());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_MINUTE, meta.getMinute());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_SECOND, meta.getSecond());
		
	}
	
	@Override
	public Moment newInstance() {
		return new Moment();
	}
}
