package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItem;

public class MetaTimerItemJSONHandler extends AbstractTimerJSONHandler<MetaTimerItem> {

	@Override
	public void fromJSONImpl(MetaTimerItem meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setTrigger(json.optString(JSONConstants.TIMER_TRIGGER));
		meta.setRepeat(json.optBoolean(JSONConstants.TIMER_REPEAT));
		meta.setCycleInterval(json.optString(JSONConstants.TIMER_CYCLE_INTERVAL));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTimerItem meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_TRIGGER, meta.getTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_REPEAT, meta.isRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_CYCLE_INTERVAL, meta.getCycleInterval());
	}
	
	@Override
	public MetaTimerItem newInstance() {
		return new MetaTimerItem();
	}
}
