package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationLine;

public class MetaRelationLineJSONHandler extends AbstractJSONHandler<MetaRelationLine, BPMSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaRelationLine meta, JSONObject json) throws Throwable {
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setTgtnodeID(json.optInt(JSONConstants.RELATION_TGTNODEID));
		meta.setTableKey(json.optString(JSONConstants.RELATION_TABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.RELATION_COLUMNKEY));
		meta.setNextColumn(json.optString(JSONConstants.RELATION_NEXTCOLUMN));
		meta.setExplandSQL(json.optString(JSONConstants.RELATION_EXPLANDSQL));
		meta.setID(json.optInt(JSONConstants.COMMON_ID));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRelationLine meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_TGTNODEID, meta.getTgtnodeID());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_NEXTCOLUMN, meta.getNextColumn());
		JSONHelper.writeToJSON(json, JSONConstants.RELATION_EXPLANDSQL, meta.getExplandSQL());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ID, meta.getID());
		
	}
	
	@Override
	public MetaRelationLine newInstance() {
		return new MetaRelationLine();
	}
}
