package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermExternalLink;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePermItem;

public class MetaPermJSONHandler extends AbstractJSONHandler<MetaPerm, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaPerm meta, JSONObject json) throws Throwable {
		meta.setFormKey(json.optString(JSONConstants.FORM_KEY));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_VISIBLEPERM);
		if(array != null){
			MetaVisiblePerm visiblePerm = new MetaVisiblePerm();
			visiblePerm.addAll(BPMJSONHandlerUtil.unbuild(MetaVisiblePermItem.class, array));
			meta.setVisiblePerm(visiblePerm);
		}
		array = json.optJSONArray(JSONConstants.BPM_ENABLEPERM);
		if(array != null){
			MetaEnablePerm enablePerm = new MetaEnablePerm();
			enablePerm.addAll(BPMJSONHandlerUtil.unbuild(MetaEnablePermItem.class, array));
			meta.setEnablePerm(enablePerm);
		}
		array = json.optJSONArray(JSONConstants.BPM_OPTPERM);
		if(array != null){
			MetaOptPerm optPerm = new MetaOptPerm();
			optPerm.addAll(BPMJSONHandlerUtil.unbuild(MetaOptPermItem.class, array));
			meta.setOptPerm(optPerm);
		}
		JSONObject o = json.optJSONObject(JSONConstants.BPM_PERMEXTERNALLINK);
		if(o != null){
			MetaPermExternalLink permExternalLink = BPMJSONHandlerUtil.unbuild(MetaPermExternalLink.class, o);
			meta.setPermExternalLink(permExternalLink);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaPerm meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.FORM_KEY, meta.getFormKey());
		
		MetaVisiblePerm visiblePerm = meta.getVisiblePerm();
		if(visiblePerm != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, visiblePerm);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_VISIBLEPERM, array);
		}
		MetaEnablePerm enablePerm = meta.getEnablePerm();
		if(enablePerm != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, enablePerm);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_ENABLEPERM, array);
		}
		MetaOptPerm optPerm = meta.getOptPerm();
		if(optPerm != null){
			JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, optPerm);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_OPTPERM, array);
		}
		MetaPermExternalLink permExternalLink = meta.getPermExternalLink();
		if(permExternalLink != null){
			JSONObject o = BPMJSONHandlerUtil.build(permExternalLink, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PERMEXTERNALLINK, o);
		}
	}
	
	@Override
	public MetaPerm newInstance() {
		return new MetaPerm();
	}
}
