package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaPreCondition;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataSpecification;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

public abstract class MetaNodeJSONHandler<T extends MetaNode> extends AbstractBPMElementJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setBPMKey(json.optString(JSONConstants.NODE_PROCESSKEY));
		meta.setInUse(json.optBoolean(JSONConstants.NODE_INUSE));
		meta.setTag(json.optString(JSONConstants.NODE_TAG));
		meta.setUserData(json.optString(JSONConstants.NODE_USER_DATA));
		meta.setWorkitemRevoke(json.optBoolean(JSONConstants.NODE_WORKITEM_REVOKE));
		meta.setRevokeCondition(json.optString(JSONConstants.NODE_REVOKE_CONDITION));
		meta.setRetreatCaption(json.optString(JSONConstants.RETREAT_CAPTION));
		meta.setTemplateKey(json.optString(JSONConstants.NODE_TEMPLATEKEY));
		meta.setBPMState(json.optInt(JSONConstants.NODE_BPMSTATE));
		meta.setRevokeTrigger(json.optString(JSONConstants.NODE_REVOKE_TRIGGER));
		meta.setRefDocKey(json.optString(JSONConstants.NODE_REF_DOC_KEY));
		meta.setRefType(json.optInt(JSONConstants.NODE_REF_TYPE));
		meta.setPattern(json.optString(JSONConstants.NODE_PATTERN));
		meta.setStop(json.optBoolean(JSONConstants.NODE_STOP));
		meta.setSync(json.optBoolean(JSONConstants.ISSYNC));
		meta.setLockWorkitem(json.optInt(JSONConstants.LOCK_WORKITEM));
		meta.setExcluded(json.optBoolean(JSONConstants.NODE_EXCLUDED));
		
		JSONArray array = json.optJSONArray(JSONConstants.BPM_TRANSITIONCOLLECTION);
		if(array != null){
			MetaTransitionCollection transitionCollection = new MetaTransitionCollection();
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaSequenceFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					transitionCollection.add(BPMJSONHandlerUtil.unbuild(MetaSequenceFlow.class, jsonObject));
				}else if(MetaExceptionFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					transitionCollection.add(BPMJSONHandlerUtil.unbuild(MetaExceptionFlow.class, jsonObject));
				}else if(MetaAssociation.TAG_NAME.equalsIgnoreCase(tagName)){
					transitionCollection.add(BPMJSONHandlerUtil.unbuild(MetaAssociation.class, jsonObject));
				}else if(MetaDefaultSequenceFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					transitionCollection.add(BPMJSONHandlerUtil.unbuild(MetaDefaultSequenceFlow.class, jsonObject));
				}
			}
			meta.setTransitionCollection(transitionCollection);
		}
		JSONObject o = json.optJSONObject(JSONConstants.BPM_DATASPECIFICATION);
		if(o != null){
			MetaDataSpecification dataSpecification = BPMJSONHandlerUtil.unbuild(MetaDataSpecification.class, o);
			meta.setDataSpecification(dataSpecification);
		}
		o = json.optJSONObject(JSONConstants.BPM_NODEGRAPHIC);
		if(o != null){
			MetaNodeGraphic graphic = BPMJSONHandlerUtil.unbuild(MetaNodeGraphic.class, o);
			meta.setNodeGraphic(graphic);
		}
		o = json.optJSONObject(JSONConstants.BPM_NODEATTACHMENT);
		if(o != null){
			MetaNodeAttachment nodeAttachment = BPMJSONHandlerUtil.unbuild(MetaNodeAttachment.class, o);
			meta.setNodeAttachment(nodeAttachment);
		}
		o = json.optJSONObject(JSONConstants.BPM_PRECONDITION);
		if(o != null){
			MetaPreCondition preCondition = BPMJSONHandlerUtil.unbuild(MetaPreCondition.class, o);
			meta.setPreCondition(preCondition);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		String caption = hook.getProcessString(GroupKeyTable.STR_BPM_NODE, meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.NODE_PROCESSKEY, meta.getBPMKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_INUSE, meta.isInUse());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_USER_DATA, meta.getUserData());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_WORKITEM_REVOKE, meta.isWorkitemRevoke());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_REVOKE_CONDITION, meta.getRevokeCondition());
		JSONHelper.writeToJSON(json, JSONConstants.RETREAT_CAPTION, meta.getRetreatCaption());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_TEMPLATEKEY, meta.getTemplateKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_BPMSTATE, meta.getBPMState());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_REVOKE_TRIGGER, meta.getRevokeTrigger());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_REF_DOC_KEY, meta.getRefDocKey());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_REF_TYPE, meta.getRefType());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_PATTERN, meta.getPattern());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_STOP, meta.getStop());
		JSONHelper.writeToJSON(json, JSONConstants.ISSYNC, meta.isSync());
		JSONHelper.writeToJSON(json, JSONConstants.LOCK_WORKITEM, meta.getLockWorkitem());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_EXCLUDED, meta.isExcluded());
		
		MetaTransitionCollection transitionCollection = meta.getTransitionCollection();
		if(transitionCollection != null){
			JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, transitionCollection);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_TRANSITIONCOLLECTION, array);
		}
		MetaDataSpecification dataSpecification = meta.getDataSpecification();
		if(dataSpecification != null){
			JSONObject o = BPMJSONHandlerUtil.build(dataSpecification, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_DATASPECIFICATION, o);
		}
		MetaNodeGraphic graphic = meta.getNodeGraphic();
		if(graphic != null){
			JSONObject o = BPMJSONHandlerUtil.build(graphic, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_NODEGRAPHIC, o);
		}
		MetaNodeAttachment nodeAttachment = meta.getNodeAttachment();
		if(nodeAttachment != null){
			JSONObject o = BPMJSONHandlerUtil.build(nodeAttachment, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_NODEATTACHMENT, o);
		}
		MetaPreCondition preCondition = meta.getPreCondition();
		if(preCondition != null){
			JSONObject o = BPMJSONHandlerUtil.build(preCondition, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_PRECONDITION, o);
		}
	}
}
