package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;

public class MetaNodeAttachmentJSONHandler extends AbstractJSONHandler<MetaNodeAttachment, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaNodeAttachment meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNodeAttachment meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		
	}
	
	@Override
	public MetaNodeAttachment newInstance() {
		return new MetaNodeAttachment();
	}
}
