package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessage;

public class MetaMessageJSONHandler extends AbstractJSONHandler<MetaMessage, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaMessage meta, JSONObject json) throws Throwable {
		meta.setDestination(json.optString(JSONConstants.MESSAGE_DESTINATION));
		meta.setDefaultMessage(json.optString(JSONConstants.MESSAGE_DEFAULT_MESSAGE));
		meta.setGeneratorImpl(json.optString(JSONConstants.MESSAGE_GENERATOR_IMPL));
		meta.setSendImpl(json.optString(JSONConstants.MESSAGE_SEND_IMPL));
		meta.setResendTimes(json.optInt(JSONConstants.MESSAGE_RESENDTIMES));
		meta.setTimeout(json.optLong(JSONConstants.MESSAGE_TIMEOUT));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaMessage meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_DESTINATION, meta.getDestination());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_DEFAULT_MESSAGE, meta.getDefaultMessage());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_GENERATOR_IMPL, meta.getGeneratorImpl());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_SEND_IMPL, meta.getSendImpl());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_RESENDTIMES, meta.getResendTimes());
		JSONHelper.writeToJSON(json, JSONConstants.MESSAGE_TIMEOUT, meta.getTimeout());
		
	}
	
	@Override
	public MetaMessage newInstance() {
		return new MetaMessage();
	}
}
