package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;

public class MetaDefaultSequenceFlowJSONHandler extends MetaSequenceFlowJSONHandler<MetaDefaultSequenceFlow> {

	@Override
	public void fromJSONImpl(MetaDefaultSequenceFlow meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setDefaultFlow(json.optBoolean(JSONConstants.TRANSITION_DEFAULT_FLOW));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDefaultSequenceFlow meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.TRANSITION_DEFAULT_FLOW, meta.isDefaultFlow());
	}
	
	@Override
	public MetaDefaultSequenceFlow newInstance() {
		return new MetaDefaultSequenceFlow();
	}
}
