package com.bokesoft.yes.meta.json;

import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.i18n.I18NInfo;
import com.bokesoft.yigo.tools.ve.VE;

public class DefaultSerializeContext extends AbstractSerializeContext {
	private MetaForm metaForm = null;

	public DefaultSerializeContext(MetaForm metaForm, VE ve) {
		super(ve);
		this.metaForm = metaForm;
	}

	public MetaForm getMetaForm() {
		return metaForm;
	}

	public String getFormKey() {
		return metaForm.getKey();
	}

	public String getString(String group, String groupKey, String word, String org) throws Throwable {
		IMetaFactory metaFactory = ve.getMetaFactory();
		if (!metaFactory.getSolution().isEnableMultiLang()) {
			return org;
		}
		String s = null;
		String lang = ve.getEnv().getLocale();
		String key = group;
		if (groupKey != null && !groupKey.isEmpty()) {
			key += "-" + groupKey;
		}
		if (GroupKeyTable.parse(group) == GroupKeyTable.UI) {
			s = metaForm.getUILangCaption(lang, key);
			if (s != null) {
				return s;
			}
		}
		return MetaUtil.getLocalString(metaFactory, metaForm, lang, key, word, org, s);
	}

	/**
	 * 获取名称翻译词条
	 *
	 * @param group      词条分组
	 * @param groupKey   词条分组标志
	 * @param word       词条关键字
	 * @param org        原词条内容
	 * @param metaObject 配置对象
	 * @return 翻译后的词条内容
	 * @throws Throwable 异常
	 */
	public String getCaptionString(String group, String groupKey, String word, String org, AbstractMetaObject metaObject) throws Throwable {
		return getCaptionString(group, groupKey, word, org, metaObject, false);
	}

	/**
	 * 获取名称翻译词条
	 *
	 * @param group      词条分组
	 * @param groupKey   词条分组标志
	 * @param word       词条关键字
	 * @param org        原词条内容
	 * @param metaObject 配置对象
	 * @param useFull    是否使用全称
	 * @return 翻译后的词条内容
	 * @throws Throwable 异常
	 */
	public String getCaptionString(String group, String groupKey, String word, String org, AbstractMetaObject metaObject, boolean useFull) throws Throwable {
		IMetaFactory metaFactory = ve.getMetaFactory();
		if (!metaFactory.getSolution().isEnableMultiLang()) {
			return org;
		}
		String s = null;
		String lang = ve.getEnv().getLocale();
		String key = group;
		if (groupKey != null && !groupKey.isEmpty()) {
			key += "-" + groupKey;
		}
		if (GroupKeyTable.parse(group) == GroupKeyTable.UI) {
			s = metaForm.getUILangCaption(lang, key);
			if (s != null) {
				return s;
			}
		}
		MetaLang metaLang = metaFactory.getSolution().getLangConfig().get(lang);
		return I18NInfo.getInstance().getLocalCaptionString(metaFactory, metaForm, lang, key, word, org, s, metaLang, metaObject, useFull);
	}
}
