package com.bokesoft.yes.meta.json;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public abstract class AbstractSerializeContext implements ISerializeContext {
	
	protected VE ve;

	public AbstractSerializeContext(VE ve) {
		super();
		this.ve = ve;
	}
	
	@Override
	public VE getVE() {
		return ve;
	}

	@Override
	public String getDataObjectString(String dataObjectKey, String org) throws Throwable {
		IMetaFactory metaFactory = ve.getMetaFactory();
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return org;
		}
		
		String lang = ve.getEnv().getLocale();
		
		return MetaUtil.getDataObjectString(metaFactory, lang, dataObjectKey, org);
	}
	
	@Override
	public String getDataObjectString(String dataObjectKey, String tableKey, String colKey, String org) throws Throwable{
		IMetaFactory metaFactory = ve.getMetaFactory();
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return org;
		}
		
		String lang = ve.getEnv().getLocale();
		
		return MetaUtil.getDataObjectString(metaFactory, lang, dataObjectKey, tableKey, colKey, org);
	}
}
