/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.util;

import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.ReportJSONHandlerMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportJSONHandlerUtil {
    public static JSONObject build(AbstractMetaObject meta, ISerializeContext hook) throws Throwable {
        String controlType = meta.getTagName();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = ReportJSONHandlerMap.getHandler(controlType);
        JSONObject model = null;
        if (handler != null) {
            model = handler.toJSON(meta, hook);
        }
        return model;
    }

    public static <T> T unbuild(Class<T> clazz, JSONObject json) throws Throwable {
        AbstractMetaObject meta = (AbstractMetaObject)clazz.newInstance();
        String controlType = meta.getTagName();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = ReportJSONHandlerMap.getHandler(controlType);
        if (handler != null) {
            handler.fromJSONImpl(meta, json);
        }
        return (T)meta;
    }

    public static AbstractMetaObject unbuild(JSONObject json) throws Throwable {
        String tagName = json.optString("tagName");
        AbstractMetaObject meta = null;
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = ReportJSONHandlerMap.getHandler(tagName);
        if (handler != null) {
            meta = handler.newInstance();
            handler.fromJSONImpl(meta, json);
        }
        return meta;
    }

    public static <T> List<T> unbuild(Class<T> clazz, JSONArray array) throws Throwable {
        ArrayList<T> list = new ArrayList<T>();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            list.add(ReportJSONHandlerUtil.unbuild(clazz, array.getJSONObject(i)));
        }
        return list;
    }

    public static JSONArray buildNoKeyCollection(ISerializeContext hook, GenericNoKeyCollection<? extends AbstractMetaObject> collection) throws Throwable {
        JSONArray array = new JSONArray();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = null;
        for (AbstractMetaObject c : collection) {
            handler = ReportJSONHandlerMap.getHandler(c.getTagName());
            if (handler == null) continue;
            array.put((Object)handler.toJSON(c, hook));
        }
        return array;
    }

    public static JSONArray buildKeyCollection(ISerializeContext hook, GenericKeyCollection<? extends AbstractMetaObject> collection) throws Throwable {
        JSONArray array = new JSONArray();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = null;
        for (AbstractMetaObject c : collection) {
            handler = ReportJSONHandlerMap.getHandler(c.getTagName());
            if (handler == null) continue;
            array.put((Object)handler.toJSON(c, hook));
        }
        return array;
    }

    public static JSONArray buildKeyWithKeyCollection(ISerializeContext hook, GenericKeyCollectionWithKey<? extends AbstractMetaObject> collection) throws Throwable {
        JSONArray array = new JSONArray();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = null;
        for (AbstractMetaObject c : collection) {
            handler = ReportJSONHandlerMap.getHandler(c.getTagName());
            if (handler == null) continue;
            array.put((Object)handler.toJSON(c, hook));
        }
        return array;
    }

    public static JSONArray buildNoKeyWithKeyCollection(ISerializeContext hook, GenericNoKeyCollectionWithKey<? extends AbstractMetaObject> collection) throws Throwable {
        JSONArray array = new JSONArray();
        AbstractJSONHandler<AbstractMetaObject, ISerializeContext> handler = null;
        for (AbstractMetaObject c : collection) {
            handler = ReportJSONHandlerMap.getHandler(c.getTagName());
            if (handler == null) continue;
            array.put((Object)handler.toJSON(c, hook));
        }
        return array;
    }
}

