package com.bokesoft.yes.meta.json.setting;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;

public class MetaSettingJSONHandler extends AbstractJSONHandler<MetaSetting,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaSetting meta, SolutionSerializeContext ctx) throws Throwable {
		MetaLoginSetting loginSetting = meta.getLogin();
		if( loginSetting != null ) {
			JSONObject o = UIJSONHandlerUtil.build(loginSetting, ctx);
			JSONHelper.writeToJSON(json, JSONConstants.SETTING_LOGINETTING, o);
		}
		
		MetaSession metaSession = meta.getSession();
		if( metaSession != null ) {
			JSONObject o = UIJSONHandlerUtil.build(metaSession, ctx);
			JSONHelper.writeToJSON(json, JSONConstants.SETTING_SESSION, o);
		}
	}

	@Override
	public MetaSetting newInstance() {
		return new MetaSetting();
	}

	@Override
	public void fromJSONImpl(MetaSetting meta, JSONObject json) throws Throwable {
		JSONObject o = json.optJSONObject(JSONConstants.SETTING_LOGINETTING);
		if( o != null ) {
			MetaLoginSetting loginSetting = UIJSONHandlerUtil.unbuild(MetaLoginSetting.class, o);
			meta.setLogin(loginSetting);
		}
		
		o = json.optJSONObject(JSONConstants.SETTING_SESSION);
		if( o != null ) {
			MetaSession session = UIJSONHandlerUtil.unbuild(MetaSession.class, o);
			meta.setSession(session);
		}
	}

}
