package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportWaterprint;

public class MetaReportWaterprintJSONHandler extends AbstractJSONHandler<MetaReportWaterprint,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportWaterprint meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCE, meta.getSource());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_REPEAT, meta.isRepeat());
	}

	@Override
	public MetaReportWaterprint newInstance() {
		return new MetaReportWaterprint();
	}

	@Override
	public void fromJSONImpl(MetaReportWaterprint meta, JSONObject json) throws Throwable {
		meta.setSource(json.optString(JSONConstants.REPORT_SOURCE));
		meta.setWidth(json.optInt(JSONConstants.COMMON_WIDTH));
		meta.setHeight(json.optInt(JSONConstants.COMMON_HEIGHT));
		meta.setRepeat(json.optBoolean(JSONConstants.REPORT_REPEAT));
	}

}
