package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.report.MetaReportRowExpand;

public class MetaReportRowExpandJSONHandler extends MetaBaseScriptJSONHandler<MetaReportRowExpand,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportRowExpand meta, SolutionSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAG, meta.getTag());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ITEMKEY, meta.getItemKey());
	}
	
	@Override
	public void fromJSONImpl(MetaReportRowExpand meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setDataType(json.optInt(JSONConstants.COMMON_DATATYPE));
		meta.setTag(json.optString(JSONConstants.COMMON_TAG));
		meta.setItemKey(json.optString(JSONConstants.REPORT_ITEMKEY));
	}
	
	@Override
	public MetaReportRowExpand newInstance() {
		return new MetaReportRowExpand();
	}
}
