package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;

public class MetaTabPanelJSONHandler extends BasePanelJSONHandler<MetaTabPanel> {
	
	@Override
	public void fromJSONImpl(MetaTabPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setTabPosition(json.optInt(JSONConstants.TABPANEL_TABPOSITION));
		meta.setTabMode(json.optInt(JSONConstants.TABPANEL_TABMODE));
		meta.setIndicatorColor(json.optString(JSONConstants.TABPANEL_INDICATORCOLOR));
		meta.setShowHead(json.optBoolean(JSONConstants.TABPANEL_SHOWHEAD));
		meta.setHoverHead(json.optBoolean(JSONConstants.TABPANEL_HOVERHEAD));
		
		String s = json.optString(JSONConstants.TABPANEL_INDICATORHEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setIndicatorHeight(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.TABPANEL_ITEMCHANGED);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.TABPANEL_ITEMCHANGED);
			script.setContent(s);
			meta.setItemChanged(script);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTabPanel meta,DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
				
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABPOSITION, meta.getTabPosition());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABMODE, meta.getTabMode());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORCOLOR, meta.getIndicatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_SHOWHEAD, meta.isShowHead());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_HOVERHEAD, meta.isHoverHead());
		
		DefSize indicatorHeight = meta.getIndicatorHeight();
		if( indicatorHeight != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORHEIGHT, indicatorHeight.toString(), "");
		}
		MetaBaseScript itemChanged = meta.getItemChanged();
		if( itemChanged != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_ITEMCHANGED, itemChanged.getContent().trim());
		}
	}

	@Override
	public MetaTabPanel newInstance() {
		return new MetaTabPanel();
	}
}
