package com.bokesoft.yes.meta.json.panel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;

public class MetaSlidingLayoutPanelJSONHandler extends BaseComponentJSONHandler<MetaSlidingLayoutPanel> {
	
	@Override
	public void fromJSONImpl(MetaSlidingLayoutPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setStyle(json.optInt(JSONConstants.SLIDINGPANEL_STYLE));
		meta.setSlidingPosition(json.optInt(JSONConstants.SLIDINGPANEL_SLIDINGPOSITION));
		
		String s = json.optString(JSONConstants.SLIDINGPANEL_LEFTWIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setLeftWidth(DefSize.parse(s));
		}
		
		s = json.optString(JSONConstants.SLIDINGPANEL_RIGHTWIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setRightWidth(DefSize.parse(s));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.SLIDINGPANEL_MAINPANEL);
		if( o != null ) {
			MetaComponent main = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setMainComponent(main);
		}
		
		o = json.optJSONObject(JSONConstants.SLIDINGPANEL_FIRSTPANEL);
		if( o != null ) {
			MetaComponent first = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setFirstComponent(first);
		}
		
		o = json.optJSONObject(JSONConstants.SLIDINGPANEL_SECONDPANEL);
		if( o != null ) {
			MetaComponent second = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setSecondComponent(second);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSlidingLayoutPanel meta,
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_SLIDING);
		
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_SLIDINGPOSITION, meta.getSlidingPosition());
		
		DefSize leftWidth = meta.getLeftWidth();
		if( leftWidth != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_LEFTWIDTH, leftWidth.toString(), "");
		}
		DefSize rightWidth = meta.getRightWidth();
		if( rightWidth != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_RIGHTWIDTH, rightWidth.toString(), "");
		}
		
		MetaComponent main = meta.getMainComponent();
		if( main != null ) {
			JSONObject o = UIJSONHandlerUtil.build(main,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_MAINPANEL, o);
		}
		MetaComponent first = meta.getFirstComponent();
		if( first != null ) {
			JSONObject o = UIJSONHandlerUtil.build(first,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_FIRSTPANEL, o);
		}
		MetaComponent second = meta.getSecondComponent();
		if( second != null ) {
			JSONObject o = UIJSONHandlerUtil.build(second,hook);
			JSONHelper.writeToJSON(json, JSONConstants.SLIDINGPANEL_SECONDPANEL, o);
		}
	}

	@Override
	public MetaSlidingLayoutPanel newInstance() {
		return new MetaSlidingLayoutPanel();
	}
}
